# Documentation for Short Codes in the AddThis WordPress Plugin

## About

Short codes can be used by any user when creating or editing a post or page. To include an AddThis tool anywhere inside a post, you can use the following shortcodes.

## List

1. sharing button short codes:
  1. addthis_sharing_buttons
  1. addthis_original_sharing_buttons
  1. addthis_custom_sharing_buttons
  1. addthis_jumbo_sharing_buttons
  1. addthis_responsive_sharing_buttons
1. follow button short codes
  1. addthis_horizontal_follow_buttons
  1. addthis_vertical_follow_buttons
  1. addthis_custom_follow_buttons
1. recommended content short codes
  1. addthis_horizontal_recommended_content
  1. addthis_vertical_recommended_content
1. for pesky themes not following WordPress conventions
  1. addthis_script

## Syntax Examples

### Adding a sharing button inside a post
```
Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent at arcu at velit mattis efficitur porttitor quis elit. Nam tincidunt nisi sit amet pretium interdum. Pellentesque feugiat dignissim nunc in imperdiet. Vestibulum ac nisl vitae diam elementum sollicitudin. Aenean massa purus, ornare non sem in, feugiat porta velit. Sed viverra gravida metus quis dignissim. Praesent fermentum iaculis quam non ultricies. Mauris non dolor nunc.

Sharing is caring:
[addthis_sharing_buttons]

Maecenas in dapibus ligula, eu consectetur orci. Sed purus ex, interdum ac consectetur gravida, porttitor ut dui. Maecenas dolor dolor, sollicitudin et sagittis sit amet, tincidunt eget odio. Maecenas auctor congue varius. Nulla enim ipsum, porttitor vitae dapibus nec, mollis a libero. Fusce tincidunt, est lacinia bibendum accumsan, ligula erat feugiat libero, non porta sapien ipsum vel dolor. Aliquam a eleifend dolor, a egestas purus. Aliquam pulvinar luctus ipsum, vel interdum nulla blandit at. Curabitur ac sem vel lectus pulvinar condimentum. Quisque tellus velit, aliquet a scelerisque sit amet, pharetra vitae augue. Sed porta mi vehicula fermentum accumsan. Integer fermentum quam placerat odio sagittis tincidunt.
``

### Adding follow buttons at the top of a post
```
[addthis_horizontal_follow_buttons]

Nullam tincidunt, tortor eu faucibus egestas, dolor tellus venenatis arcu, ut accumsan mi tortor id neque. Praesent convallis libero id odio hendrerit bibendum. In finibus odio sit amet fringilla ornare. Etiam dui quam, dapibus eget diam eu, aliquet rhoncus elit. Praesent at ligula quis mauris porttitor bibendum in sed purus. Vestibulum quis venenatis nisl. Suspendisse auctor eleifend neque, pulvinar volutpat orci auctor sed. Praesent sed gravida lorem. Integer euismod quam arcu, sed viverra sem aliquam a. Integer eu lacus venenatis, tincidunt massa ut, efficitur augue.

Sed a rutrum lectus. In ac rhoncus ligula. Mauris velit odio, ullamcorper ac ipsum vel, molestie mollis purus. Etiam commodo venenatis enim sed sagittis. Nam et congue nisi. In in tellus tellus. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Nunc in felis ultricies, sodales est in, pellentesque metus. Phasellus non nibh dolor. Nam ac leo eu eros dignissim aliquam sed vel arcu.
```
